#!/usr/bin/env bash

# Bootstrap wrapper to run the flip‑count simulator and the Volume 4
# Wilson‑loop pipeline.  Provided here for convenience when starting
# from within the ar-operator-core repository.  It assumes that this
# repository is located adjacent to ``vol4-flip-count-simulator`` and
# ``vol4-discrete-gauge-wilson-loop``.

set -euo pipefail

# Determine workspace root (parent directory of this repo)
ROOT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && cd .. && pwd)"

echo "[bootstrap] Running flip‑count simulator"
python "$ROOT_DIR/vol4-flip-count-simulator/scripts/generate_flip_counts.py"

echo "[bootstrap] Running Wilson‑loop pipeline"
python "$ROOT_DIR/vol4-wilson-loop-pipeline/run_simulation.py" --config "$ROOT_DIR/vol4-wilson-loop-pipeline/config.yaml"

echo "[bootstrap] Complete"